/*
 * GLWorldScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLWORLDSCENE_HPP_
#define GLWORLDSCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qobject.h>

#include <iosfwd>

#include <boost/thread/recursive_mutex.hpp>

#include "Bond/bond.hpp"
#include "GLMoleculeObject_bond.hpp"
#include "GLMoleculeObject_molecule.hpp"
#include "types.hpp"

class atom;
class molecule;
class Shape;

class QGLPainter;
class QGLSceneNode;
class QGLView;

class GLMoleculeObject;
class GLMoleculeObject_atom;
class GLMoleculeObject_molecule;
class GLMoleculeObject_shape;

/** This class contains a list of all molecules in the world.
 *
 */
class GLWorldScene : public QObject
{
  Q_OBJECT
public:
  GLWorldScene(QObject *parent=0);
  virtual ~GLWorldScene();

//#if !defined(QT_OPENGL_ES_1)
//  PerPixelEffect *lighting;
//#endif

  void changeMaterials(bool perPixel);
  QGLSceneNode* getAtom(size_t);
  QGLSceneNode* getMolecule(size_t);
  QGLSceneNode* getBond(size_t, size_t);

  void initialize(QGLView *view, QGLPainter *painter) const;
  void draw(QGLPainter *painter, const QVector4D &cameraPlane) const;

  enum SelectionModeType{
    SelectAtom,
    SelectMolecule
  };
  void setSelectionMode(SelectionModeType mode);

signals:
  void changed();
  void updated();
  void changeOccured();
  void pressed();
  void released();
  void clicked();
  void clicked(atomId_t);
  void doubleClicked();
  void hoverChanged(const atomId_t);
  void hoverChanged(const moleculeId_t, int);

private slots:
  void atomClicked(atomId_t no);
  void moleculeClicked(moleculeId_t no);
  void moleculeRemoved(const moleculeId_t _id);
  void moleculeInserted(const moleculeId_t _id);
  void atomRemoved(const moleculeId_t _molid, const atomId_t _atomid);
  void atomInserted(const moleculeId_t _molid, const atomId_t _atomid);
  void setSelectionModeAtom();
  void setSelectionModeMolecule();
  void addShape();
  void removeShape();
  void update();
  void moleculesVisibilityChanged(const moleculeId_t _id, bool _visible);
  void changeMoleculeId(GLMoleculeObject_molecule *, const moleculeId_t, const moleculeId_t);

public:
  void updateSelectedShapes();

private:

  typedef std::set<moleculeId_t> RemovalMolecule_t;
  //!> list of molecule ids whose moleculeRemoved we have received but who have not been inserted yet
  RemovalMolecule_t RemovalMolecules;

  typedef std::map< moleculeId_t , GLMoleculeObject_molecule* > MoleculeNodeMap;
  typedef std::map< std::string , GLMoleculeObject_shape* > ShapeNodeMap;
  MoleculeNodeMap MoleculesinSceneMap;
  ShapeNodeMap ShapesinSceneMap;

  //!> enumeration of all possible changes molecule might have missed before instantiation
  enum StateChangeType {
    atomInsertedState,
    atomRemovedState,
    MAX_StateChangeType
  };
  typedef std::multimap< atomId_t, StateChangeType> StateChangeMap_t;
  typedef std::map< moleculeId_t, StateChangeMap_t> MoleculeMissedStateMap_t;
  //!> map of all missed state changes
  MoleculeMissedStateMap_t MoleculeMissedStateMap;
  //!> flag to indicate whether state map is currently worked on
  boost::recursive_mutex MoleculeMissedStateMap_mutex;

  SelectionModeType selectionMode;
};

#endif /* GLWORLDSCENE_HPP_ */
