/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CommandLineWindow.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <boost/bind.hpp>

#include "CommandLineUI/CommandLineWindow.hpp"
#include "CommandLineUI/CommandLineStatusIndicator.hpp"

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"

#include "CommandLineParser.hpp"

#include <iostream>

using namespace std;

// TODO: see what code can be moved to a base class for Graphic and CommandLine Windows
CommandLineWindow::CommandLineWindow()
{
  // Add status indicators etc...
  statusIndicator = new CommandLineStatusIndicator();
}

CommandLineWindow::~CommandLineWindow()
{
  delete statusIndicator;
}

void CommandLineWindow::display() {
  //cout << ActionRegistry::getInstance();

  // go through all possible actions
  for (std::list<std::string>::iterator CommandRunner = CommandLineParser::getInstance().SequenceOfActions.begin(); CommandRunner != CommandLineParser::getInstance().SequenceOfActions.end(); ++CommandRunner) {
    cout << "Checking presence of " << *CommandRunner << ": ";
    if (ActionRegistry::getInstance().isActionPresentByName(*CommandRunner)) {
      cout << "calling " << *CommandRunner << endl;
      ActionRegistry::getInstance().getActionByName(*CommandRunner)->call();
    } else {
      cout << "absent." << endl;
    }
  }
}

