/*
 * HeaderPrinter.hpp
 *
 *  Created on: Aug 3, 2012
 *      Author: heber
 */

#ifndef HEADERPRINTER_HPP_
#define HEADERPRINTER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/fusion/sequence.hpp>
#include <string>

#include "Fragmentation/Summation/printKeyNames.hpp"

/** HeaderPrinter prints the header for a table of values each associated to a
 * specific boost::fusion-style key \a MapKey.
 *
 * We require the printName() function
 * specialized for each \a MapKey to print the name for this value.
 *
 * This is made such that we may use boost::mpl::for_each to quickly create
 * the header line if specialized printName()s and a boost::fusion::vector
 * containing all these keys is present
 */
struct HeaderPrinter {
  HeaderPrinter(const std::string &init) :
    header(init)
  {}

  template <typename MapKey>
  void operator()(MapKey &) {
    header += std::string("\t") + printKeyNames::printName<MapKey>();
  }

  const std::string &get() const {
    return header;
  }

private:
  std::string header;
};


#endif /* HEADERPRINTER_HPP_ */
