#ifndef VECTOR_HPP_
#define VECTOR_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_multimin.h>

#include "defs.hpp"

/********************************************** declarations *******************************/

/** Single vector.
 * basically, just a x[3] but with helpful functions
 */
class Vector {
  public:
    double x[NDIM];

  Vector();
  Vector(const double x1, const double x2, const double x3);
  ~Vector();

  double Distance(const Vector * const y) const;
  double DistanceSquared(const Vector * const y) const;
  double DistanceToPlane(const Vector * const PlaneNormal, const Vector * const PlaneOffset) const;
  double PeriodicDistance(const Vector * const y, const double * const cell_size) const;
  double PeriodicDistanceSquared(const Vector * const y, const double * const cell_size) const;
  double ScalarProduct(const Vector * const y) const;
  double Norm() const;
  double NormSquared() const;
  double Angle(const Vector * const y) const;
  bool IsZero() const;
  bool IsOne() const;
  bool IsNormalTo(const Vector * const normal) const;
  bool IsEqualTo(const Vector * const a) const;

  void AddVector(const Vector * const y);
  void SubtractVector(const Vector * const y);
  void CopyVector(const Vector * const y);
  void CopyVector(const Vector &y);
  void RotateVector(const Vector * const y, const double alpha);
  void VectorProduct(const Vector * const y);
  void ProjectOntoPlane(const Vector * const y);
  void ProjectIt(const Vector * const y);
  Vector Projection(const Vector * const y) const;
  void Zero();
  void One(const double one);
  void Init(const double x1, const double x2, const double x3);
  void Normalize();
  void Translate(const Vector * const x);
  void Mirror(const Vector * const x);
  void Scale(const double ** const factor);
  void Scale(const double * const factor);
  void Scale(const double factor);
  void MatrixMultiplication(const double * const M);
  void InverseMatrixMultiplication(const double * const M);
  void KeepPeriodic(const double * const matrix);
  void LinearCombinationOfVectors(const Vector * const x1, const Vector * const x2, const Vector * const x3, const double * const factors);
  double CutsPlaneAt(const Vector * const A, const Vector * const B, const Vector * const C) const;
  bool GetIntersectionWithPlane(const Vector * const PlaneNormal, const Vector * const PlaneOffset, const Vector * const Origin, const Vector * const LineVector);
  bool GetIntersectionOfTwoLinesOnPlane(const Vector * const Line1a, const Vector * const Line1b, const Vector * const Line2a, const Vector * const Line2b, const Vector *Normal = NULL);
  bool GetOneNormalVector(const Vector * const x1);
  bool MakeNormalVector(const Vector * const y1);
  bool MakeNormalVector(const Vector * const y1, const Vector * const y2);
  bool MakeNormalVector(const Vector * const x1, const Vector * const x2, const Vector * const x3);
  bool SolveSystem(Vector * x1, Vector * x2, Vector * y, const double alpha, const double beta, const double c);
  bool LSQdistance(const Vector ** vectors, int dim);
  void AskPosition(const double * const cell_size, const bool check);
  void Output() const;
  bool IsInParallelepiped(const Vector &offset, const double * const parallelepiped) const;
  void WrapPeriodically(const double * const M, const double * const Minv);
};

ostream & operator << (ostream& ost, const Vector &m);
bool operator==(const Vector& a, const Vector& b);
Vector& operator+=(Vector& a, const Vector& b);
Vector& operator-=(Vector& a, const Vector& b);
Vector& operator*=(Vector& a, const double m);
Vector& operator*(const Vector& a, const double m);
Vector& operator*(const double m, const Vector& a);
Vector& operator+(const Vector& a, const Vector& b);
Vector& operator-(const Vector& a, const Vector& b);


#endif /*VECTOR_HPP_*/
