/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveParticleParametersAction.cpp
 *
 *  Created on: Feb 27, 2016
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// and before MemDebug due to placement new
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "Actions/PotentialAction/SaveParticleParametersAction.hpp"

#include <boost/filesystem.hpp>
#include <fstream>

#include "CodePatterns/Log.hpp"

#include "Potentials/Exceptions.hpp"
#include "Potentials/Particles/ParticleRegistry.hpp"
#include "Potentials/RegistrySerializer.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveParticleParametersAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

ActionState::ptr PotentialSaveParticleParametersAction::performCall()
{
  // store the particles
  if (!params.particle_file.get().string().empty()) {
    // print fitted particles
    std::stringstream particles;
    try {
      RegistrySerializer<Particle> serialize(
          particles,
          ParticleRegistry::getInstance(),
          std::string("particle"));
      serialize();
    } catch (SerializerStreamException &e) {
      STATUS("Error parsing stream, ended too early?");
    }
    LOG(1, "STATUS: Resulting parameters are " << std::endl << particles.str());
    std::ofstream returnstream(params.particle_file.get().string().c_str());
    if (returnstream.good()) {
      returnstream << particles.str();
    } else {
      STATUS("Could not open stream to write particles!");
      return Action::failure;
    }
  } else {
    STATUS("No existing potential file given!");
    return Action::failure;
  }

  return Action::success;
}

ActionState::ptr PotentialSaveParticleParametersAction::performUndo(ActionState::ptr _state) {
  STATUS("Undo of PotentialSaveParticleParametersAction not implemented.");
  return Action::failure;
}

ActionState::ptr PotentialSaveParticleParametersAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of PotentialSaveParticleParametersAction not implemented.");
  return Action::failure;
}

bool PotentialSaveParticleParametersAction::canUndo() {
  return false;
}

bool PotentialSaveParticleParametersAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
