/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DipoleAngularCorrelationAction.cpp
 *
 *  Created on: Feb 11, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Analysis/analysis_correlation.hpp"
#include "Tesselation/boundary.hpp"
#include "linkedcell.hpp"
#include "CodePatterns/Log.hpp"
#include "Element/element.hpp"
#include "molecule.hpp"
#include "Element/periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AnalysisAction/DipoleAngularCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "DipoleAngularCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisDipoleAngularCorrelationAction::performCall() {
  //int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());
  DipoleAngularCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  LOG(0, "STATUS: There are " << molecules.size() << " selected molecules.");
  ASSERT(!params.periodic, "AnalysisDipoleAngularCorrelationAction() - periodic case not implemented.");
  correlationmap = DipoleAngularCorrelation(molecules);
  OutputCorrelationMap<DipoleAngularCorrelationMap>(&output, correlationmap, OutputDipoleAngularCorrelation_Header, OutputDipoleAngularCorrelation_Value);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisDipoleAngularCorrelationAction::canUndo() {
  return true;
}

bool AnalysisDipoleAngularCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
