/*
 * VMGDebugGridJob.hpp
 *
 *  Created on: Aug 31, 2012
 *      Author: heber
 */

#ifndef VMGDEBUGGRIDJOB_HPP_
#define VMGDEBUGGRIDJOB_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/export.hpp"
#include "boost/serialization/vector.hpp"

#include "JobMarket/Jobs/FragmentJob.hpp"
#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

#include <vector>

/** This class encapsulates a Debug Grid Job.
 *
 *  VMGDebugGridJob just stores the sampled grid into a VMG job and lets VMG
 *  print the grid in a VTK compatible format to make use of its grid_viewer
 *  for debugging purposes.
 *
 */
class VMGDebugGridJob : public FragmentJob
{
public:
  /** Constructor for class VMGDebugGridJob.
   *
   * @param _JobId id of the job
   * @param _density_grid sampled electron charge density from short-range solutions
   * @param OpenBoundaryConditions states whether we have open (true) or periodic
   *        (false) boundary conditions
   */
  VMGDebugGridJob(const JobId_t _JobId,
      const SamplingGrid &density_grid,
      const bool _OpenBoundaryConditions = false);
  virtual ~VMGDebugGridJob();

  FragmentResult::ptr Work();

private:
  void InitVMG();

private:
  //!> sampled density required as input
  const SamplingGrid density_grid;
  //!> states whether we have open (true) or periodic (false) boundary conditions
  const bool OpenBoundaryConditions;

private:
  /** private default cstor for serialization only
   */
  VMGDebugGridJob();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
    ar & const_cast< SamplingGrid &>(density_grid);
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(VMGDebugGridJob)

#endif /* VMGDEBUGGRIDJOB_HPP_ */
