#!/usr/bin/python
#
# gathers all Actions in pyMoleCuilder module and tests them with some default
# values.
#
# date: Oct 5, 2011
# author: Gregor Bollerhey

import pyMoleCuilder as mol
import sys, re, subprocess

# cmd given?
if len(sys.argv) < 1:
  sys.stderr.write("Usage: "+sys.argv[0]+" <cmd>\n")
  sys.exit(255)

cmd = sys.argv[1]

# options.dat einlesen

Defaults = {}

with open('options.dat') as f:
    for line in f:
        if len(line) > 0 and line[0] != '#':
            try:
              key, value = line.split('\t', 1)
            except ValueError:
              print "line needs two values, tab-separated: "+line
              sys.exit(1)
            value = value[1:-2] # quotes entfernen
        
            Defaults[key] = value

# aufrufen

Allparams = []

def ParseParameters(docstring):
    result = []
    params = re.findall(r'\(str\)([-a-zA-Z]*)', docstring)

    for param in params:
        if not param in Allparams:
            Allparams.append(param)
            
            if not param in Defaults:
                print 'Fehlender Defaultwert:', param
        
        # direkt substituieren, oder erst beim aufruf?
        if param in Defaults:
            param = Defaults[param]
        
        result.append(param)

    return result

doc = eval('mol.%s.__doc__' % cmd)
params = ParseParameters(doc)

print '--BEGIN-- %s mit %s --------' % (cmd, params)
   
# write command to file
output=open("test.py", "w")
output.write('import pyMoleCuilder as mol\nparams = %s\nmol.%s(*params)\nmol.wait()\n' % (params, cmd))
output.close()
# call python externally on this file and catch retcode
p = subprocess.Popen(["python", "test.py"], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = p.communicate()
print ' --- STDOUT ---'
print ' %s ' % (stdout)
print ' --- STDERR ---'
print ' %s ' % (stderr)
retcode = p.returncode
if retcode == 134 or retcode == 0:
  print ' ---- ok ----'
else:
  print ' -- FAILED with %s --' % (retcode)
#  if retcode == 1:
#    sys.exit(1)
#exec('mol.%s(*params)' % cmd)

print '---END--- %s mit %s --------' % (cmd, params)

sys.exit(0)
