/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ShutdownWorkerOperation.cpp
 *
 *  Created on: 11.12.2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <iostream>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "CodePatterns/Info.hpp"
#include "ControllerChoices.hpp"
#include "Jobs/SystemCommandJob.hpp"
#include "JobId.hpp"

#include "Controller/Commands/ShutdownWorkerOperation.hpp"

FragmentJob::ptr ShutdownWorkerOperation::NoJob(new SystemCommandJob(std::string(""), std::string(""), JobId::NoJob));

/** Virtual internal function to give shutdown choice.
 *
 */
void ShutdownWorkerOperation::internal()
{
  Info info(__FUNCTION__);

  // send the NoJob
  connection_.sync_write(NoJob);
}
