/*
 * NotAllAtomsInsideSphereAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAllAtomsInsideSphereAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAllAtomsInsideSphereState : public ActionState {
public:
  SelectionNotAllAtomsInsideSphereState(std::vector<atom*> _selectedAtoms, const Vector &_position, const double _radius) :
    selectedAtoms(_selectedAtoms),
    position(_position),
    radius(_radius)
  {}
  std::vector<atom*> selectedAtoms;
  Vector position;
  double radius;
};

const char SelectionNotAllAtomsInsideSphereAction::NAME[] = "unselect-atoms-inside-sphere";

SelectionNotAllAtomsInsideSphereAction::SelectionNotAllAtomsInsideSphereAction() :
  Action(NAME)
{}

SelectionNotAllAtomsInsideSphereAction::~SelectionNotAllAtomsInsideSphereAction()
{}

void SelectionNotAllAtomsInsideSphere(const Vector &position, const double radius) {
  ValueStorage::getInstance().setCurrentValue(SelectionNotAllAtomsInsideSphereAction::NAME, radius);
  ValueStorage::getInstance().setCurrentValue("position", position);
  ActionRegistry::getInstance().getActionByName(SelectionNotAllAtomsInsideSphereAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAllAtomsInsideSphereAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryDouble(NAME, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryVector("position", false, ValueStorage::getInstance().getDescription("position"));

  return dialog;
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  double radius = 0.;
  Vector position;

  ValueStorage::getInstance().queryCurrentValue(NAME, radius);
  ValueStorage::getInstance().queryCurrentValue("position", position);

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms inside a sphere at " << position << " with radius " << radius << "." << endl);
  Shape s = translate(resize(Sphere(),radius),position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));
  return Action::state_ptr(new SelectionNotAllAtomsInsideSphereState(selectedAtoms, position, radius));
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionNotAllAtomsInsideSphereState(state->selectedAtoms, state->position, state->radius));
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  Shape s = translate(resize(Sphere(),state->radius),state->position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));

  return Action::state_ptr(new SelectionNotAllAtomsInsideSphereState(state->selectedAtoms, state->position, state->radius));
}

bool SelectionNotAllAtomsInsideSphereAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsInsideSphereAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsInsideSphereAction::getName() {
  return NAME;
}
