/*
 * NotAllAtomsInsideCuboidAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAllAtomsInsideCuboidAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAllAtomsInsideCuboidState : public ActionState {
public:
  SelectionNotAllAtomsInsideCuboidState(std::vector<atom*> _selectedAtoms, const Vector &_position, const Vector &_extension) :
    selectedAtoms(_selectedAtoms),
    position(_position),
    extension(_extension)
  {}
  std::vector<atom*> selectedAtoms;
  Vector position;
  Vector extension;
};

const char SelectionNotAllAtomsInsideCuboidAction::NAME[] = "unselect-atoms-inside-cuboid";

SelectionNotAllAtomsInsideCuboidAction::SelectionNotAllAtomsInsideCuboidAction() :
  Action(NAME)
{}

SelectionNotAllAtomsInsideCuboidAction::~SelectionNotAllAtomsInsideCuboidAction()
{}

void SelectionNotAllAtomsInsideCuboid(const Vector &position, const Vector &extension) {
  ValueStorage::getInstance().setCurrentValue(SelectionNotAllAtomsInsideCuboidAction::NAME, extension);
  ValueStorage::getInstance().setCurrentValue("position", position);
  ActionRegistry::getInstance().getActionByName(SelectionNotAllAtomsInsideCuboidAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAllAtomsInsideCuboidAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryVector(NAME, false, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryVector("position", false, ValueStorage::getInstance().getDescription("position"));

  return dialog;
}

Action::state_ptr SelectionNotAllAtomsInsideCuboidAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  Vector position;
  Vector extension;

  ValueStorage::getInstance().queryCurrentValue("position", position);
  ValueStorage::getInstance().queryCurrentValue(NAME, extension);

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms inside a cuboid at " << position << " and extension of " << extension << "." << endl);
  Shape s = translate(stretch(Cuboid(),extension),position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));
  return Action::state_ptr(new SelectionNotAllAtomsInsideCuboidState(selectedAtoms, position, extension));
}

Action::state_ptr SelectionNotAllAtomsInsideCuboidAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsInsideCuboidState *state = assert_cast<SelectionNotAllAtomsInsideCuboidState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionNotAllAtomsInsideCuboidState(state->selectedAtoms, state->position, state->extension));
}

Action::state_ptr SelectionNotAllAtomsInsideCuboidAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsInsideCuboidState *state = assert_cast<SelectionNotAllAtomsInsideCuboidState*>(_state.get());

  Shape s = translate(stretch(Cuboid(),state->extension),state->position);
  World::getInstance().unselectAllAtoms(AtomByShape(s));

  return Action::state_ptr(new SelectionNotAllAtomsInsideCuboidState(state->selectedAtoms, state->position, state->extension));
}

bool SelectionNotAllAtomsInsideCuboidAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsInsideCuboidAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsInsideCuboidAction::getName() {
  return NAME;
}
