/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::StringTextQuery::StringTextQuery(Parameter<std::string> &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::string>(_param, title,_description)
{}

TextDialog::StringTextQuery::~StringTextQuery() {}

bool TextDialog::StringTextQuery::handle() {
  std::cout << getDescription() << ": ";
  getline(std::cin,temp);
  param.set(temp);
  return true;
}

