/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"


TextDialog::RealSpaceMatrixTextQuery::RealSpaceMatrixTextQuery(Parameter<RealSpaceMatrix> &_param, std::string title, std::string _description) :
    Dialog::TQuery<RealSpaceMatrix>(_param, title,_description)
{}

TextDialog::RealSpaceMatrixTextQuery::~RealSpaceMatrixTextQuery()
{}

bool TextDialog::RealSpaceMatrixTextQuery::handle() {
  std::cout << getTitle();

  double dtemp[6];
  std::cout << getDescription() << " - ";
  std::string coords[6] = {"xx","yx","yy", "zx", "zy", "zz"};
  for (int i=0;i<6;i++) {
    std::cout << coords[i] << ": ";
    std::cin >> dtemp[i];
  }
  temp.set(0,0, dtemp[0]);
  temp.set(0,1, dtemp[1]);
  temp.set(0,2, dtemp[2]);
  temp.set(1,0, dtemp[1]);
  temp.set(1,1, dtemp[3]);
  temp.set(1,2, dtemp[4]);
  temp.set(2,0, dtemp[2]);
  temp.set(2,1, dtemp[4]);
  temp.set(2,2, dtemp[5]);
  param.set(temp);
  return true;
}

