/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C) 2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FilesTextQuery.cpp
 *
 *  Created on: May 21, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem.hpp>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::FilesTextQuery::FilesTextQuery(Parameter<std::vector< boost::filesystem::path> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<boost::filesystem::path> >(_param, title,_description)
{}

TextDialog::FilesTextQuery::~FilesTextQuery() {}

bool TextDialog::FilesTextQuery::handle() {
  std::vector<boost::filesystem::path> tempfiles;
  bool badInput = false;
  bool continueflag = true;
  do {
    std::string tempstring;
    do{
      badInput = false;
      std::cout << getDescription() << ": ";
      std::cin >> tempstring;
      if(std::cin.fail()){
        badInput = true;
        std::cin.clear();
        std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
        std::cout << "Input was not a valid file!" << std::endl;
        continue;
      }
    } while(badInput);
    boost::filesystem::path tempfile;
    tempfile = tempstring;
    std::cout << "Enter another file [y/n]? ";
    std::cin >> tempstring;
    if (tempstring != "y")
      continueflag = false;
    tempfiles.push_back(tempfile);
  } while(continueflag);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  param.set(tempfiles);
  return true;
}

