/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <boost/lexical_cast.hpp>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

using boost::lexical_cast;
using boost::bad_lexical_cast;


TextDialog::ElementsTextQuery::ElementsTextQuery(Parameter<std::vector<const element *> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<const element *> >(_param, title,_description)
{}

TextDialog::ElementsTextQuery::~ElementsTextQuery()
{}

bool TextDialog::ElementsTextQuery::handle() {
  std::string shorthand;
  int Z=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  const element *temp_element;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(std::string(iter, olditer));
      stream >> shorthand;
      try {
        Z = lexical_cast<int>(shorthand);
        temp_element = World::getInstance().getPeriode()->FindElement(Z);
      } catch (bad_lexical_cast) {
        temp_element = World::getInstance().getPeriode()->FindElement(shorthand.c_str());
      };
      if(!temp_element && Z!=-1){
        std::cout << "Invalid Element" << shorthand << std::endl;
        break;
      }
      temp.push_back(temp_element);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> shorthand;
    try {
      Z = lexical_cast<int>(shorthand);
      temp_element = World::getInstance().getPeriode()->FindElement(Z);
    } catch (bad_lexical_cast) {
      temp_element = World::getInstance().getPeriode()->FindElement(shorthand.c_str());
    };
    if(!temp_element && Z!=-1) {
      std::cout << "Invalid Element" << shorthand << std::endl;
      temp.push_back(temp_element);
    }
  }
  param.set(temp);

  return (Z!=-1);
}

