/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoublesTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::DoublesTextQuery::DoublesTextQuery(Parameter<std::vector<double> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<double> >(_param, title,_description)
{}

TextDialog::DoublesTextQuery::~DoublesTextQuery() {}

bool TextDialog::DoublesTextQuery::handle() {
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  double temp_element;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(std::string(iter, olditer));
      stream >> temp_element;
      temp.push_back(temp_element);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> temp_element;
    temp.push_back(temp_element);
  }
  param.set(temp);

  return true;
}

