/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

TextDialog::AtomTextQuery::AtomTextQuery(Parameter<const atom *> &_param, std::string title, std::string _description) :
    Dialog::TQuery<const atom *>(_param, title,_description)
{}

TextDialog::AtomTextQuery::~AtomTextQuery() {}

bool TextDialog::AtomTextQuery::handle() {
  int idxOfAtom=-1;
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> idxOfAtom;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }

    temp = World::getInstance().getAtom(AtomById(idxOfAtom));
    if(!temp && idxOfAtom!=-1){
      std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
      badInput = true;
    }else
      param.set(temp);

  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return (idxOfAtom!=-1);
}


