/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QDoubleSpinBox>
#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"


QtDialog::VectorQtQuery::VectorQtQuery(Parameter<Vector> &_param, std::string title, QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<Vector>(_param, title),
    parent(_parent),
    dialog(_dialog)
{
  temp = Vector(0, 0, 0);
  if (param.isSet())
    temp = param.get();
  mainLayout= new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  mainLayout->addWidget(titleLabel);
  subLayout = new QVBoxLayout();
  mainLayout->addLayout(subLayout);
  QComboBox* inputBox = new QComboBox();
  coordLayout = new QHBoxLayout();
  subLayout->addLayout(coordLayout);
  coordLabel = new QLabel(QString("x,y,z"));
  coordLayout->addWidget(coordLabel);
  coordInputX = new QDoubleSpinBox();
  coordInputX->setRange(-std::numeric_limits<double>::max(),std::numeric_limits<double>::max());
  coordInputX->setValue(temp[0]);
//  coordInputX->setRange(0,M.at(i,i));
  coordInputX->setDecimals(3);
  coordLayout->addWidget(coordInputX);
  coordInputY = new QDoubleSpinBox();
  coordInputY->setRange(-std::numeric_limits<double>::max(),std::numeric_limits<double>::max());
  coordInputY->setValue(temp[1]);
//  coordInputY->setRange(0,M.at(i,i));
  coordInputY->setDecimals(3);
  coordLayout->addWidget(coordInputY);
  coordInputZ = new QDoubleSpinBox();
  coordInputZ->setRange(-std::numeric_limits<double>::max(),std::numeric_limits<double>::max());
  coordInputZ->setValue(temp[2]);
//  coordInputZ->setRange(0,M.at(i,i));
  coordInputZ->setDecimals(3);
  coordLayout->addWidget(coordInputZ);
  connect(coordInputX,SIGNAL(valueChanged(double)),this,SLOT(onUpdateX(double)));
  connect(coordInputY,SIGNAL(valueChanged(double)),this,SLOT(onUpdateY(double)));
  connect(coordInputZ,SIGNAL(valueChanged(double)),this,SLOT(onUpdateZ(double)));
  parent->addLayout(mainLayout);
}

QtDialog::VectorQtQuery::~VectorQtQuery()
{}

void QtDialog::VectorQtQuery::onUpdateX(double newDouble) {
  temp[0] = newDouble;
  dialog->update();
}

void QtDialog::VectorQtQuery::onUpdateY(double newDouble) {
  temp[1] = newDouble;
  dialog->update();
}

void QtDialog::VectorQtQuery::onUpdateZ(double newDouble) {
  temp[2] = newDouble;
  dialog->update();
}

bool QtDialog::VectorQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


