/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"


QtDialog::UnsignedIntsQtQuery::UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<std::vector<unsigned int> >(_param, _title),
    QtQueryList<unsigned int>(_parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this);
  subQuery = new UnsignedIntQtQuery(*subParam, _title, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::UnsignedIntsQtQuery::~UnsignedIntsQtQuery()
{
  delete(subQuery);
}

void QtDialog::UnsignedIntsQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::UnsignedIntsQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::UnsignedIntsQtQuery::onAddElement() {
  addElement();
}

void QtDialog::UnsignedIntsQtQuery::onRemoveElement() {
  removeElements();
}

bool QtDialog::UnsignedIntsQtQuery::handle()
{
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}



