/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qspinbox.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"


QtDialog::UnsignedIntQtQuery::UnsignedIntQtQuery(Parameter<unsigned int> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<unsigned int>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  temp = 0;
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QSpinBox();
  inputBox->setValue(temp);
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  onUpdate(inputBox->value());
  connect(inputBox,SIGNAL(valueChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::UnsignedIntQtQuery::~UnsignedIntQtQuery()
{
}

void QtDialog::UnsignedIntQtQuery::onUpdate(int newUnsignedInt) {
  temp = newUnsignedInt;
  dialog->update();
}

bool QtDialog::UnsignedIntQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}

