/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qtablewidget.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"

QtDialog::RealSpaceMatrixQtQuery::RealSpaceMatrixQtQuery(Parameter<RealSpaceMatrix> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<RealSpaceMatrix>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));

  // init input table
  inputTable = new QTableWidget(3,3);
  QStringList CoordinateList;
  CoordinateList << "x" << "y" << "z";
  inputTable->setHorizontalHeaderLabels(CoordinateList);
  inputTable->setVerticalHeaderLabels(CoordinateList);

  // fill the box with current matrix
  const RealSpaceMatrix &domain = World::getInstance().getDomain().getM();
  for (int i=0;i<3;i++)
    for (int j=0;j<3;j++) {
      QTableWidgetItem *newItem = new QTableWidgetItem(tr("%1").arg(domain.at(i,j)));
      inputTable->setItem(i,j,newItem);
      onUpdate(i,j);
    }

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputTable);

  connect(inputTable,SIGNAL(cellChanged(int,int)),this,SLOT(onUpdate(int,int)));
}

QtDialog::RealSpaceMatrixQtQuery::~RealSpaceMatrixQtQuery()
{
}

void QtDialog::RealSpaceMatrixQtQuery::onUpdate(int row, int column)
{
  temp.at(row, column) = inputTable->item(row, column)->text().toDouble();
  dialog->update();
}

bool QtDialog::RealSpaceMatrixQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


