/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FilesQtQuery.cpp
 *
 *  Created on: May 21, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"


#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"


QtDialog::FilesQtQuery::FilesQtQuery(Parameter<std::vector<boost::filesystem::path> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<std::vector<boost::filesystem::path> >(_param, _title),
    QtQueryList<boost::filesystem::path>(_parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this);
  subQuery = new FileQtQuery(*subParam, _title, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::FilesQtQuery::~FilesQtQuery()
{
  delete(subQuery);
}

void QtDialog::FilesQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::FilesQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::FilesQtQuery::onAddElement() {
  addElement();
}

void QtDialog::FilesQtQuery::onRemoveElement() {
  removeElements();
}

bool QtDialog::FilesQtQuery::handle()
{
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


