/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"


#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"


QtDialog::ElementsQtQuery::ElementsQtQuery(Parameter<std::vector<const element *> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<std::vector<const element *> >(_param, _title),
    QtQueryList<const element *>(_parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this);
  subQuery = new ElementQtQuery(*subParam, _title, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::ElementsQtQuery::~ElementsQtQuery()
{
  delete(subQuery);
}

void QtDialog::ElementsQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::ElementsQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::ElementsQtQuery::onAddElement() {
  addElement();
}

void QtDialog::ElementsQtQuery::onRemoveElement() {
  removeElements();
}

bool QtDialog::ElementsQtQuery::handle()
{
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


