/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

QtDialog::ElementQtQuery::ElementQtQuery(Parameter<const element *> &_param, std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    Dialog::TQuery<const element *>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  periodentafel *periode = World::getInstance().getPeriode();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QComboBox();
  for(periodentafel::const_iterator iter = periode->begin();
      iter!=periode->end();
      ++iter)
  {
    std::stringstream sstr;
    sstr << (*iter).first << "\t" << (*iter).second->getName();
    inputBox->addItem(QString(sstr.str().c_str()),QVariant((*iter).first));
  }
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  onUpdate(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::ElementQtQuery::~ElementQtQuery()
{
}

void QtDialog::ElementQtQuery::onUpdate(int newIndex) {
  QVariant data = inputBox->itemData(newIndex);
  int idx = data.toInt();
  temp = World::getInstance().getPeriode()->FindElement(idx);
  dialog->update();
}

bool QtDialog::ElementQtQuery::handle(){
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


