/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoubleQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QDoubleSpinBox>
#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"


QtDialog::DoubleQtQuery::DoubleQtQuery(Parameter<double> &_param, std::string title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<double>(_param, title),
    parent(_parent),
    dialog(_dialog)
{
  temp = 0.0;
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QDoubleSpinBox();
  inputBox->setValue(temp);
  inputBox->setRange(-std::numeric_limits<double>::max(),std::numeric_limits<double>::max());
  inputBox->setDecimals(3);
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  connect(inputBox,SIGNAL(valueChanged(double)),this,SLOT(onUpdate(double)));
}

QtDialog::DoubleQtQuery::~DoubleQtQuery()
{
  //delete pipe;
}

void QtDialog::DoubleQtQuery::onUpdate(double newDbl) {
  temp = newDbl;
  dialog->update();
}

bool QtDialog::DoubleQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


