/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"

QtDialog::AtomQtQuery::AtomQtQuery(Parameter<const atom *> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::TQuery<const atom *>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QComboBox();
  inputBox->insertItem(-1, QString("no atom"));
  std::vector<atom *> atoms = World::getInstance().getAllAtoms();
  for (std::vector<atom *>::const_iterator iter = atoms.begin(); iter != atoms.end(); ++iter)
    inputBox->insertItem((*iter)->getNr(),QString::fromStdString((*iter)->getName()));

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  onUpdate(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::AtomQtQuery::~AtomQtQuery()
{
}

void QtDialog::AtomQtQuery::onUpdate(int newIndex) {
  QVariant data = inputBox->itemData(newIndex);
  int idx = data.toInt();
  temp = World::getInstance().getAtom(AtomById(idx));
  dialog->update();
}

bool QtDialog::AtomQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


