/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <vector>

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::VectorsCommandLineQuery::VectorsCommandLineQuery(Parameter<std::vector<Vector> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<Vector> >(_param, title, _description)
{}

CommandLineDialog::VectorsCommandLineQuery::~VectorsCommandLineQuery()
{}

bool CommandLineDialog::VectorsCommandLineQuery::handle() {
  std::vector<VectorValue> temporary;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temporary = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<VectorValue> >();
    for(std::vector<VectorValue>::iterator iter = temporary.begin(); iter != temporary.end(); ++iter) {
      Vector temp_element = (*iter).toVector();
      temp.push_back(temp_element);
    }
    param.set(temp);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing vectors for " << getTitle() << ".");
    return false;
  }
}

