/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberDistribution_ParametersCommandLineQuery.cpp
 *
 *  Created on: Jan 06, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <sstream>
#include <string>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "RandomNumbers/RandomNumberDistribution_Parameters.hpp"

CommandLineDialog::RandomNumberDistribution_ParametersCommandLineQuery::RandomNumberDistribution_ParametersCommandLineQuery(Parameter<RandomNumberDistribution_Parameters> &_param, std::string title, std::string _description) :
    Dialog::TQuery<RandomNumberDistribution_Parameters>(_param, title, _description)
{}

CommandLineDialog::RandomNumberDistribution_ParametersCommandLineQuery::~RandomNumberDistribution_ParametersCommandLineQuery() {}

bool CommandLineDialog::RandomNumberDistribution_ParametersCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    std::string stringtext = CommandLineParser::getInstance().vm[getTitle()].as<std::string>();
    std::stringstream text(stringtext);
//    LOG(1, "INFO: Parameter set from CommandLine is '" << text.str() << "'");
    text >> temp;
    param.set(temp);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing RandomNumberDistribution_Parameters for " << getTitle() << ".");
    return false;
  }
}

