/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::MoleculeCommandLineQuery::MoleculeCommandLineQuery(Parameter<const molecule *> &_param, std::string title, std::string _description) :
    Dialog::TQuery<const molecule *>(_param, title, _description)
{}

CommandLineDialog::MoleculeCommandLineQuery::~MoleculeCommandLineQuery() {}

bool CommandLineDialog::MoleculeCommandLineQuery::handle() {
  int IdxOfMol = -1;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfMol = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    param.set(World::getInstance().getMolecule(MoleculeById(IdxOfMol)));
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing molecule for " << getTitle() << ".");
    return false;
  }
}

