/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::AtomsCommandLineQuery::AtomsCommandLineQuery(Parameter<std::vector<const atom *> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<const atom *> >(_param, title, _description)
{}

CommandLineDialog::AtomsCommandLineQuery::~AtomsCommandLineQuery() {}

bool CommandLineDialog::AtomsCommandLineQuery::handle() {
  std::vector<int> IdxOfAtom;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfAtom = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    const atom *temp_element;
    for (std::vector<int>::iterator iter = IdxOfAtom.begin(); iter != IdxOfAtom.end(); ++iter) {
      temp_element = World::getInstance().getAtom(AtomById(*iter));
      if (temp_element)
        temp.push_back(temp_element);
    }
    param.set(temp);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing atoms for " << getTitle() << ".");
    return false;
  }
}

