/*
 * ParserPsi3UnitTest.hpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */
#ifndef PARSERPSI3UNITTEST_HPP_
#define PARSERPSI3UNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Parser/Psi3Parser.hpp"

#include <cppunit/extensions/HelperMacros.h>
#include <string>

class ParserPsi3UnitTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ParserPsi3UnitTest ) ;
  CPPUNIT_TEST ( ParameterDefaultTest );
  CPPUNIT_TEST ( ParameterSetterTest );
  CPPUNIT_TEST ( ParameterCloneTest );
  CPPUNIT_TEST ( readPsi3Test );
  CPPUNIT_TEST ( writePsi3Test );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void ParameterDefaultTest();
  void ParameterSetterTest();
  void ParameterCloneTest();
  void readPsi3Test();
  void writePsi3Test();

private:
  FormatParser<psi3> *parser;
};

#endif /* PARSERPSI3UNITTEST_HPP_ */
