/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculesQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qpushbutton.h>
#include <Qt/qboxlayout.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Query/QtQueryList.hpp"
#include "UIElements/Qt4/Pipe/QtQueryListPipe.hpp"


QtDialog::MoleculesQtQuery::MoleculesQtQuery(Parameter<std::vector<const molecule *> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::MoleculesQuery(_param, _title),
    QtQueryList<const molecule *>(_parent, _dialog, temp)
{
  ListQuerySubDialog *subDialog = new ListQuerySubDialog(this);
  subQuery = new MoleculeQtQuery(*subParam, _title, thisVLayout, subDialog);
  subDialog->setSubQuery(subQuery);

  connect(inputList,SIGNAL(itemSelectionChanged()),this,SLOT(onElementSelected()));
  connect(addButton,SIGNAL(clicked()),this,SLOT(onAddElement()));
  connect(removeButton,SIGNAL(clicked()),this,SLOT(onRemoveElement()));
}

QtDialog::MoleculesQtQuery::~MoleculesQtQuery()
{
  delete(subQuery);
}

void QtDialog::MoleculesQtQuery::onSubUpdate()
{
  addButton->setEnabled(subParam->isSet());
}

void QtDialog::MoleculesQtQuery::onElementSelected() {
  elementSelected();
}

void QtDialog::MoleculesQtQuery::onAddElement() {
  addElement();
}

void QtDialog::MoleculesQtQuery::onRemoveElement() {
  removeElements();
}

bool QtDialog::MoleculesQtQuery::handle()
{
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}



