/*
 * BondGraphUnitTest.hpp
 *
 *  Created on: Oct 29, 2009
 *      Author: heber
 */

#ifndef BONDGRAPHUNITTEST_HPP_
#define BONDGRAPHUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>


class BondGraph;
class element;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class BondGraphTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( BondGraphTest) ;
    CPPUNIT_TEST ( SetupTest );
    CPPUNIT_TEST ( LoadTableTest );
    CPPUNIT_TEST ( ConstructGraphFromTableTest );
    CPPUNIT_TEST ( ConstructGraphFromCovalentRadiiTest );
    CPPUNIT_TEST ( EqualityTest );
    CPPUNIT_TEST ( SerializationTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void SetupTest();
      void LoadTableTest();
      void ConstructGraphFromTableTest();
      void ConstructGraphFromCovalentRadiiTest();
      void EqualityTest();
      void SerializationTest();

private:

      molecule *TestMolecule;
      const element *hydrogen;
      const element *carbon;

      BondGraph *BG;
      std::stringstream dummy;
      std::stringstream test;
};

#endif /* BONDGRAPHUNITTEST_HPP_ */
