/*
 * RemoveAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/RemoveAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "atom.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char AtomRemoveAction::NAME[] = "remove-atom";

AtomRemoveAction::AtomRemoveAction() :
  Action(NAME)
{}

AtomRemoveAction::~AtomRemoveAction()
{}

void AtomRemove() {
  ActionRegistry::getInstance().getActionByName(AtomRemoveAction::NAME)->call(Action::NonInteractive);
};

Dialog* AtomRemoveAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr AtomRemoveAction::performCall() {
  atom *first = NULL;

  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  for (World::AtomSelectionIterator iter = World::getInstance().beginAtomSelection(); iter != World::getInstance().endAtomSelection(); ++iter) {
    first = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Removing atom " << first->getId() << "." << endl);
    // TODO: this is not necessary when atoms and their storing to file are handled by the World
    // simply try to erase in every molecule found
    for (std::vector<molecule *>::iterator iter = molecules.begin();iter != molecules.end(); ++iter) {
      (*iter)->erase(first);
    }
    World::getInstance().destroyAtom(first);
  }
  return Action::success;
}

Action::state_ptr AtomRemoveAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomRemoveAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomRemoveAction::canUndo() {
  return false;
}

bool AtomRemoveAction::shouldUndo() {
  return false;
}

const string AtomRemoveAction::getName() {
  return NAME;
}
