/*
 * UIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */


#include <utility>
#include "Patterns/Singleton_impl.hpp"
#include "UIElements/UIFactory.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

std::map<std::string,boost::shared_ptr<UIFactory::factoryDescription> > UIFactory::factories;

UIFactory::UIFactory()
{}

UIFactory::~UIFactory()
{}

void UIFactory::makeUserInterface(std::string type) {
  ASSERT(factories.count(type),"Selected factory was not registered before creation.");
  // call the factory factory
  setInstance(factories[type]->makeFactory());
}

void UIFactory::registerFactory(factoryDescription *factoryDesc) {
  ASSERT(!factories.count(factoryDesc->name),"Trying to re-register an already registered factory.");
  factories.insert(make_pair(factoryDesc->name,
                             boost::shared_ptr<factoryDescription>(factoryDesc)));
}

CONSTRUCT_SINGLETON(UIFactory)

UIFactory::factoryDescription::factoryDescription(string _name) :
  name(_name)
{}

UIFactory::factoryDescription::~factoryDescription()
{}
