/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * FragmentationResultContainer.cpp
 *
 *  Created on: Mar 8, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FragmentationResultContainer.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Singleton_impl.hpp"

#if defined(HAVE_JOBMARKET) && defined(HAVE_VMG)
void FragmentationResultContainer::addFullResults(
    const KeySetsContainer &_keysets,
    const KeySetsContainer &_forcekeysets,
    const shortrangedata_t &_shortrangedata,
    const longrangedata_t &_longrangedata
    )
{
  OBSERVE;
  ASSERT( ResultsType == BothRanges,
      "FragmentationResultContainer::addFullResults() - mixing full and short range is not in the cards.");
  ASSERT( _keysets.KeySets.size() == _forcekeysets.KeySets.size(),
      "FragmentationResultContainer::addFullResults() - keysets ("
      +toString(_keysets.KeySets.size())+") and forcekeysets ("+toString(_forcekeysets.KeySets.size())
      +") differ in size.");
  ASSERT( _keysets.KeySets.size() == _shortrangedata.size(),
      "FragmentationResultContainer::addFullResults() - keysets ("
      +toString(_keysets.KeySets.size())+") and shortrangedata ("+toString(_shortrangedata.size())
      +") differ in size.");
  // there are more results for longrangedata!
//  ASSERT( _keysets.KeySets.size() == _longrangedata.size(),
//      "FragmentationResultContainer::addFullResults() - keysets ("
//      +toString(_keysets.KeySets.size())+") and longrangedata ("+toString(_longrangedata.size())
//      +") differ in size.");
  keysets.insert(_keysets);
  forcekeysets.insert(_forcekeysets);
  shortrangedata.insert(_shortrangedata.begin(), _shortrangedata.end());
  longrangedata.insert(_longrangedata.begin(), _longrangedata.end());
}
#endif

void FragmentationResultContainer::addShortRangeResults(
    const KeySetsContainer &_keysets,
    const KeySetsContainer &_forcekeysets,
    const shortrangedata_t &_shortrangedata
    )
{
  OBSERVE;
  ASSERT( (ResultsType == ShortRangeOnly) || (keysets.KeySets.empty()) ,
      "FragmentationResultContainer::addFullResults() - mixing full and short range is not in the cards.");
  ASSERT( _keysets.KeySets.size() == _forcekeysets.KeySets.size(),
      "FragmentationResultContainer::addFullResults() - keysets ("
      +toString(_keysets.KeySets.size())+") and forcekeysets ("+toString(_forcekeysets.KeySets.size())
      +") differ in size.");
  ASSERT( _keysets.KeySets.size() == _shortrangedata.size(),
      "FragmentationResultContainer::addFullResults() - keysets ("
      +toString(_keysets.KeySets.size())+") and shortrangedata ("+toString(_shortrangedata.size())
      +") differ in size.");
  // deteriorate to short range only
  ResultsType = ShortRangeOnly;
  keysets.insert(_keysets);
  forcekeysets.insert(_forcekeysets);
  shortrangedata.insert(_shortrangedata.begin(), _shortrangedata.end());
}

void FragmentationResultContainer::addShortRangeSummedResults(
    const FragmentationShortRangeResults::summedshortrange_t &_summedshortrange
    )
{
  OBSERVE;
  summedshortrange.insert(_summedshortrange.begin(), _summedshortrange.end());
}

#if defined(HAVE_JOBMARKET) && defined(HAVE_VMG)
const FragmentationResultContainer::longrangedata_t&
FragmentationResultContainer::getLongRangeResults() const
{
  ASSERT( ResultsType == BothRanges,
      "FragmentationResultContainer::getLongRangeResults() - access although storing only short range.");
  return longrangedata;
}
#endif

CONSTRUCT_SINGLETON(FragmentationResultContainer)
