/*
 * QTWorldView.cpp
 *
 *  Created on: Jan 21, 2010
 *      Author: crueger
 */

#include "Views/QT4/QTWorldView.hpp"

#include <iostream>

#include "atom.hpp"
#include "molecule.hpp"

using namespace std;

// maybe this should go with the definition of molecules

// some attributes need to be easier to find for molecules
// these attributes are skiped so far
const int QTWorldView::COLUMNCOUNT = COLUMNTYPES_MAX;
const char *QTWorldView::COLUMNNAMES[QTWorldView::COLUMNCOUNT]={"Name","Atoms"/*,"Formula"*//*,"Size"*/};

QTWorldView::QTWorldView(QWidget * _parent) :
  QTableWidget (_parent),
  Observer("QTWorldView")
{
  setRowCount(0);
  setColumnCount(COLUMNCOUNT);

  for(int i=0; i<COLUMNCOUNT;++i) {
    QTableWidgetItem *heading = new QTableWidgetItem();
    heading->setText(QString(COLUMNNAMES[i]));
    setHorizontalHeaderItem(i,heading);
  }

  molecules = World::getInstance().getMolecules();
  molecules->signOn(this);
  update(molecules);

  connect(this,SIGNAL(cellChanged(int,int)),this,SLOT(moleculeChanged(int,int)));
  connect(this,SIGNAL(cellClicked(int,int)),this,SLOT(cellSelected(int,int)));

}

QTWorldView::~QTWorldView()
{
  molecules->signOff(this);
}

void QTWorldView::update(Observable *publisher) {
  int numMolecules = molecules->ListOfMolecules.size();
  setRowCount(numMolecules);
  molSelection.resize(numMolecules);
  int i;
  MoleculeList::iterator iter;
  for(iter = molecules->ListOfMolecules.begin(),i=0;
      iter != molecules->ListOfMolecules.end();
      ++i,++iter) {

    const int index = (*iter)->IndexNr;
    QTableWidgetItem *indexWidget = new QTableWidgetItem();
    // there probably is an easier method to convert ints to QStrings... but i didn't find it
    stringstream idxsstr;
    idxsstr << index;
    indexWidget->setText(QString(idxsstr.str().c_str()));
    indexWidget->setData(Qt::UserRole,QVariant(index));
    setVerticalHeaderItem(i,indexWidget);

    const string name = (*iter)->getName();
    QTableWidgetItem *nameWidget = new QTableWidgetItem();
    nameWidget->setText(QString(name.c_str()));
    setItem(i,NAME,nameWidget);

    const int atomCount = (*iter)->getAtomCount();
    QTableWidgetItem *countWidget= new QTableWidgetItem();
    stringstream countsstr;
    countsstr << atomCount;
    countWidget->setText(QString(countsstr.str().c_str()));
    countWidget->setFlags(Qt::ItemIsSelectable | Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
    setItem(i,ATOMS,countWidget);

    molSelection[i]=nameWidget->isSelected();
  }
}

void QTWorldView::subjectKilled(Observable *publisher) {
}

void QTWorldView::moleculeChanged(int row, int column) {
  int idx = verticalHeaderItem(row)->data(Qt::UserRole).toInt();
  molecule *mol = molecules->ReturnIndex(idx);
  string cellValue = item(row,NAME)->text().toStdString();
  if(mol->getName() != cellValue && cellValue !="") {
    mol->setName(cellValue);
  }
  else if(cellValue==""){
    item(row,NAME)->setText(QString(mol->getName().c_str()));
  }
}


void QTWorldView::cellSelected(int row, int column){
  bool state = item(row,column)->isSelected();
  for(int i = 0; i<COLUMNCOUNT; i++){
    item(row,i)->setSelected(state);
  }
  // figure out which rows have changed
  for(int i=0; i<rowCount();++i){
    state = item(i,0)->isSelected();
    if(molSelection[i]!=state){
      int idx = verticalHeaderItem(i)->data(Qt::UserRole).toInt();
      molecule *mol = molecules->ReturnIndex(idx);
      if(state){
        emit moleculeSelected(mol);
      }
      else{
        emit moleculeUnSelected(mol);
      }
      molSelection[i]=state;
    }
  }
}
