/*
 * createMatrixNrLookup.hpp
 *
 *  Created on: Aug 31, 2012
 *      Author: heber
 */

#ifndef CREATEMATRIXNRLOOKUP_HPP_
#define CREATEMATRIXNRLOOKUP_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <vector>

#include "JobMarket/types.hpp"

/** Creates a lookup from FragmentJob::id to the true fragment  number.
 *
 * @param jobids vector with job ids
 * @param FragmentCounter total number of fragments on return
 * @return Lookup up-map
 */
std::map< JobId_t, size_t > createMatrixNrLookup(
    const std::vector<JobId_t> &jobids,
    size_t &FragmentCounter);

#endif /* CREATEMATRIXNRLOOKUP_HPP_ */
