/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * createMatrixNrLookup.cpp
 *
 *  Created on: Aug 31, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "createMatrixNrLookup.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"


std::map< JobId_t, size_t > createMatrixNrLookup(
    const std::vector<JobId_t> &jobids,
    size_t &FragmentCounter)
{
  // align fragments
  std::map< JobId_t, size_t > MatrixNrLookup;
  FragmentCounter = 0;
  for (std::vector<JobId_t>::const_iterator iter = jobids.begin();
      iter != jobids.end(); ++iter) {
    LOG(3, "DEBUG: Inserting (" << *iter << "," << FragmentCounter << ").");
#ifndef NDEBUG
    std::pair< std::map< JobId_t, size_t >::iterator, bool> inserter =
#endif
        MatrixNrLookup.insert( std::make_pair(*iter, FragmentCounter++) );
    ASSERT( inserter.second,
        "createMatrixNrLookup() - two results have same id "
        +toString(*iter)+".");
  }
  LOG(1, "INFO: There are " << FragmentCounter << " fragments.");
  return MatrixNrLookup;
}
