/*
 *    vmg - a versatile multigrid solver
 *    Copyright (C) 2012-2013 Institute for Numerical Simulation, University of Bonn
 *
 *  vmg is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vmg is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   boundary_value_setter_open.hpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Apr 15 16:21:40 2013
 *
 * @brief  For open boundary conditions.
 *
 */

#ifndef BOUNDARY_VALUE_SETTER_OPEN_HPP_
#define BOUNDARY_VALUE_SETTER_OPEN_HPP_

#include "base/math.hpp"
#include "discretization/boundary_value_setter.hpp"

namespace VMG
{

class Grid;

class BoundaryValueSetterOpen : public BoundaryValueSetter
{
public:
  BoundaryValueSetterOpen(bool _register = true) :
    BoundaryValueSetter(_register)
  {}
  virtual ~BoundaryValueSetterOpen() {}

protected:
  vmg_float greens_function(vmg_float arg) {return 1.0 / (4.0 * Math::pi * arg);}
};

}

#endif /* BOUNDARY_VALUE_SETTER_OPEN_HPP_ */
