/*
 *    vmg - a versatile multigrid solver
 *    Copyright (C) 2012-2013 Institute for Numerical Simulation, University of Bonn
 *
 *  vmg is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vmg is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   boundary_value_setter.hpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Apr 15 16:21:40 2013
 *
 * @brief  Class for setting boundary values with open
 *         boundary conditions.
 *
 */

#ifndef BOUNDARY_VALUE_SETTER_HPP_
#define BOUNDARY_VALUE_SETTER_HPP_

#include <vector>

#include "base/object.hpp"
#include "discretization/boundary_value.hpp"

namespace VMG
{

class Grid;

class BoundaryValueSetter : public Object
{
public:
  BoundaryValueSetter(bool _register = true) :
    Object("BOUNDARY_VALUE_SETTER", _register)
  {InitBoundaryValueSetter();}

  virtual ~BoundaryValueSetter();

  void ComputeBoundaryValues();

  const std::vector<BoundaryValue>& BoundaryValues() const {return boundary_values;}

protected:
  virtual vmg_float greens_function(vmg_float arg) = 0;

private:
  void InitBoundaryValueSetter();

  std::vector<BoundaryValue> boundary_values;
};

}

#endif /* BOUNDARY_VALUE_SETTER_HPP_ */
