/*
 *    vmg - a versatile multigrid solver
 *    Copyright (C) 2012-2013 Institute for Numerical Simulation, University of Bonn
 *
 *  vmg is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vmg is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @file   boundary_value.hpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Sun Apr 14 17:23:40 2013
 *
 * @brief  Holds a boundary value for open boundary
 *         conditions.
 *
 */

#ifndef BOUNDARY_VALUE_HPP_
#define BOUNDARY_VALUE_HPP_

#include "base/index.hpp"
#include "base/vector.hpp"
#include "grid/grid.hpp"

namespace VMG
{

class BoundaryValue
{
public:
  BoundaryValue() :
    _index(0),
    _pos(0.0),
    _val(0.0)
  {}

  BoundaryValue(const Grid& grid, const Index& index) :
    _index(index),
    _pos(grid.GetSpatialPosGlobal(index)),
    _val(0.0)
  {}

  vmg_float& Val() {return _val;}
  const vmg_float& Val() const {return _val;}

  const Index& GetIndex() const {return _index;}
  void SetIndex(const Grid& grid, const Index& index)
  {
    _index = index;
    _pos = grid.GetSpatialPosGlobal(index);
  }

  const Vector&  GetPos() const {return _pos;}

private:
  Index _index;
  Vector _pos;
  vmg_float _val;
};

}


#endif /* BOUNDARY_VALUE_HPP_ */
