/*
 * QtFragmentList.hpp
 *
 *  Created on: Sep 03, 2013
 *      Author: heber
 */

#ifndef QTFRAGMENTLIST_H_
#define QTFRAGMENTLIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include "CodePatterns/Observer/Observer.hpp"

#include "Fragmentation/Summation/IndexSet.hpp"

class FragmentGraph;

class QtFragmentList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtFragmentList(QWidget * _parent=0);
  virtual ~QtFragmentList();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);
  virtual void paintEvent(QPaintEvent * event);
  void refill();

  static const int COLUMNCOUNT;
  enum {NUMBER,KEYSET,FORMULA,ENERGYVALUE,ENERGYCONTRIBUTION,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void rowSelected();

signals:
  void FragmentSelected(FragmentGraph const *);
  void FragmentUnSelected(FragmentGraph const *);
  void changed();

private:
  //!> needed to determine when a selection changes
  std::vector<bool> FragmentSelection;
  //!> index set of the fragment
  std::vector<IndexSet> indexsets;
  //!> flag to indicate that we got an update
  bool dirty;
  //!> flag to indicate that we currently clear the view, avoids thread collisions
  bool clearing;
};

#endif /* QTFRAGMENTLIST_H_ */
