/*
 * EnrollInPoolOperation.hpp
 *
 *  Created on: Feb 26, 2012
 *      Author: heber
 */

#ifndef ENROLLINPOOLOPERATION_HPP_
#define ENROLLINPOOLOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Jobs/FragmentJob.hpp"
#include "Operations/AsyncOperation.hpp"
#include "Results/FragmentResult.hpp"
#include "WorkerAddress.hpp"

class EnrollInPoolOperation : public AsyncOperation  {
public:
  /// Constructor for class EnrollInPoolOperation.
  EnrollInPoolOperation(Connection &_connection, const WorkerAddress &_address) :
    AsyncOperation(std::string("enrollinpool"),_connection),
    address(_address),
    EnrollmentFlag(false)
  {}
  /// Destructor for class EnrollInPoolOperation
  ~EnrollInPoolOperation() {}

protected:
  // virtual function pointer to the connection handler
  void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Handle sending choice
  void handle_SendChoice(const boost::system::error_code& e);

  /// Handle receiving flag
  void handle_ReceiveFlag(const boost::system::error_code& e);

  /// Handle received flag
  void handle_FinishOperation(const boost::system::error_code& e);

private:
  //!> address to enroll with
  WorkerAddress address;

  //!> This flag indicates whether the server not only got out address but also returned something.
  bool EnrollmentFlag;
};


#endif /* ENROLLINPOOLOPERATION_HPP_ */
