/*
 * SendResultsOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SENDRESULTSOPERATION_HPP_
#define FRAGMENTCONTROLLER_SENDRESULTSOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"
#include "FragmentResult.hpp"

#include "Controller/Commands/Operation.hpp"

class SendResultsOperation : public Operation  {
public:
  /// Constructor for class SendResultsOperation.
  SendResultsOperation(Connection &_connection, const std::string& _host, const std::string& _service) :
    Operation(_connection, _host, _service) {}
  /// Destructor for class SendResultsOperation
  ~SendResultsOperation() {}

public:
  // placing receive jobs operations into an io_service
  virtual void operator()();

  /// Handle completion of a GetResults operation.
  void handle_connect_get(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when results are about to be received.
  void handle_ReceivingResults(const boost::system::error_code& e);

  /// Callback function when results have been received.
  void handle_ReceivedResults(const boost::system::error_code& e);

  /// internal function to connect to server and receive calculated results
  void connect_get();

  /// Getter for results
  std::vector<FragmentResult> getResults();

protected:
  /// bunch of results
  std::vector<FragmentResult> results;
};

#endif /* FRAGMENTCONTROLLER_SENDRESULTSOPERATION_HPP_ */
