/*
 * ReceiveJobsOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_RECEIVEJOBSOPERATION_HPP_
#define FRAGMENTCONTROLLER_RECEIVEJOBSOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"
#include "FragmentJob.hpp"

#include "Controller/Commands/Operation.hpp"

class ReceiveJobsOperation : public Operation {
public:
  /// Constructor for class ReceiveJobsOperation.
  ReceiveJobsOperation(Connection &_connection, const std::string& _host, const std::string& _service) :
    Operation(_connection, _host, _service) {}
  /// Destructor for class ReceiveJobsOperation
  ~ReceiveJobsOperation() {}

public:
  /// Placing receive jobs operations into an io_service
  virtual void operator()();

  /// Handle completion of a calculate operation.
  void handle_connect_calc(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when bunch of jobs have been sent.
  void handle_SendJobs(const boost::system::error_code& e);

  /// internal function to connect to server and send jobs for calculation
  void connect_calc();

  /// Setter for jobs
  void addJobs(const std::vector<FragmentJob> &jobs);

  /** Getter for number of jobs present in the queue.
   *
   * \return jobs.size()
   */
  size_t getPresentJobs() const
  {
    return jobs.size();
  }

protected:
  void handle_FinishOperation(const boost::system::error_code& e);

  /// bunch of jobs
  std::vector<FragmentJob> jobs;
};

#endif /* FRAGMENTCONTROLLER_RECEIVEJOBSOPERATION_HPP_ */
