/** \file parsing.hpp
 *
 * Definitions of various class functions for the parsing of value files.
 *    
 */


#ifndef PARSING_HPP_
#define PARSING_HPP_

// ======================================= DEFINES ==========================================

#define MYEPSILON 1e-13
#define FactorsFile "BondFragmentTE-Factors.dat"
#define ForcesFile "BondFragmentForces-Factors.dat"
#define KeySetsFile "BondFragmentKeySets.dat"
#define FragmentPrefix "BondFragment"
#define EnergySuffix ".energy.all"
#define ForcesSuffix ".forces.all"
#define TimeSuffix ".speed"
#define EnergyFragmentSuffix ".energyfragment.all"
#define ForceFragmentSuffix ".forcefragment.all"
#define OrderSuffix ".Order"

// ======================================= FUNCTIONS ==========================================

#ifdef HAVE_INLINE
inline
#endif
bool FilePresent(const char *filename);

#ifdef HAVE_INLINE
inline
#endif
bool TestParams(int argc, char **argv);

// ======================================= CLASS MatrixContainer =============================

class MatrixContainer {
  public:
    double ***Matrix;
    int **Indices;
    char *Header;
    int MatrixCounter;
    int *RowCounter;
    int ColumnCounter;
  
  MatrixContainer();
  ~MatrixContainer();
  
  bool ParseMatrix(char *name, char *prefix, char *suffix, int skiplines, int skipcolumns);
  bool AllocateMatrix(char *GivenHeader, int MCounter, int *RCounter, int CCounter);
  bool ResetMatrix();
  bool SetLastMatrix(double value, int skipcolumns);
  bool SetLastMatrix(double **values, int skipcolumns);
  //bool ParseIndices();
  //bool SumSubValues();
  bool SumSubManyBodyTerms(class MatrixContainer &Matrix, class KeySetsContainer &KeySet, int Order);
  bool WriteTotalFragments(const char *name, const char *prefix);
  bool WriteLastMatrix(const char *name, const char *prefix, const char *suffix);
}; 

// ======================================= CLASS EnergyMatrix =============================

class EnergyMatrix : public MatrixContainer {
  public:
    bool ParseIndices();
    bool SumSubEnergy(class EnergyMatrix &Fragments, class KeySetsContainer &KeySet, int Order);
};

// ======================================= CLASS ForceMatrix =============================

class ForceMatrix : public MatrixContainer {
  public: 
    bool ParseIndices(char *name);
    bool SumSubForces(class ForceMatrix &Fragments, class KeySetsContainer &KeySet, int Order);
};

// ======================================= CLASS KeySetsContainer =============================

class KeySetsContainer {
  public:
    int **KeySets;
    int *AtomCounter;
    int FragmentCounter;
    int Order;
    int *FragmentsPerOrder;
    int **OrderSet;
  
  KeySetsContainer();
  ~KeySetsContainer();
   
  bool ParseKeySets(const char *name, const int *ACounter, const int FCounter);
  bool ParseManyBodyTerms();
  bool KeySetsContainer::Contains(const int GreaterSet, const int SmallerSet);
};

// ======================================= END =============================================

#endif /*PARSING_HPP_*/
