/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * IndexSetUnitTest.cpp
 *
 *  Created on: Sep 16, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Fragmentation/Summation/IndexSet.hpp"

#include "IndexSetUnitTest.hpp"

#include <boost/assign.hpp>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace boost::assign;

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( IndexSetTest );


void IndexSetTest::setUp()
{
  indices = new IndexSet();
};


void IndexSetTest::tearDown()
{
  delete indices;
};

/** UnitTest for contains(Index_t)
 */
void IndexSetTest::contains_singleIndex_Test()
{
  Index_t index = 1;
  Index_t notindex = 2;
  indices->insert(index);

  CPPUNIT_ASSERT( indices->contains(index) );
  CPPUNIT_ASSERT( !indices->contains(notindex) );

  indices->erase(index);
  CPPUNIT_ASSERT( !indices->contains(index) );
};

/** UnitTest for contains(IndexSet)
 */
void IndexSetTest::contains_IndexSet_Test()
{
  indices->insert(1);
  IndexSet otherindices;
  otherindices += 1,2,3;
  IndexSet anotherindices;
  anotherindices += 2,3,4;

  // does not contain otherindices
  CPPUNIT_ASSERT( !indices->contains(otherindices) );
  // vice versa is true
  CPPUNIT_ASSERT( otherindices.contains(*indices) );
  CPPUNIT_ASSERT( !anotherindices.contains(otherindices) );
  CPPUNIT_ASSERT( !otherindices.contains(anotherindices) );
  // contains self
  CPPUNIT_ASSERT( indices->contains(*indices) );
};

/** UnitTest for operator==,!=,<,>()
 */
void IndexSetTest::comparatorTest()
{
  indices->insert(1);
  IndexSet otherindices;
  otherindices += 1,2,3;
  IndexSet anotherindices;
  anotherindices += 2,3,4;

  // (in)equality
  CPPUNIT_ASSERT( *indices == *indices);
  CPPUNIT_ASSERT( *indices != otherindices);
  CPPUNIT_ASSERT( *indices != anotherindices);

  // less than not equal
  CPPUNIT_ASSERT( !(*indices < *indices) );
  CPPUNIT_ASSERT( *indices < otherindices );
  CPPUNIT_ASSERT( *indices < anotherindices );
  CPPUNIT_ASSERT( otherindices < anotherindices );

  // greater than not equal
  CPPUNIT_ASSERT( !(*indices > *indices) );
  CPPUNIT_ASSERT( otherindices > *indices);
  CPPUNIT_ASSERT( anotherindices > *indices );
  CPPUNIT_ASSERT( anotherindices > otherindices );
};
