/*
 * IndexSet.hpp
 *
 *  Created on: Apr 24, 2011
 *      Author: heber
 */

#ifndef INDEXSET_HPP_
#define INDEXSET_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/shared_ptr.hpp>
#include <set>

//!> is the type of an index
typedef size_t Index_t;

/** This class represents a single set of indices along with functions to order them
 * and check whether one is contained in another.
 */
class IndexSet : public std::set<Index_t>
{
public:
  //!> typedef for instance wrapped in share_ptr
  typedef boost::shared_ptr<IndexSet> ptr;

  IndexSet();

  ~IndexSet();

  // index set contain checks
  bool contains(const IndexSet &_indexset) const;
  bool contains(const Index_t _index) const;

  // comparison
  bool operator<(const IndexSet &b) const;
  bool operator>(const IndexSet &b) const;
  bool operator==(const IndexSet &b) const;
  bool operator!=(const IndexSet &b) const
  {
    return !(*this == b);
  }

private:
};

std::ostream & operator<<(std::ostream &ost, const IndexSet &indexset);

#endif /* INDEXSET_HPP_ */
