/*
 * FragmentJob.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTJOB_HPP_
#define FRAGMENTJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "boost/serialization/array.hpp"

#include "FragmentResult.hpp"
#include "JobId.hpp"
#include "types.hpp"

class FragmentJobTest;
class FragmentQueueTest;
class FragmentWorker;

/** FragmentJob contains all information for the Worker to start the job and
 * deliver a FragmentResult.
 *
 * Important is that this class is fully serializable such that it can be
 * transfered to a scheduler (server) and be deserialized by the Worker.
 */
class FragmentJob : public JobId
{
  //!> allow FragmentQueue unit test access
  friend class FragmentQueueTest;
  //!> allow own unit test access
  friend class FragmentJobTest;
public:
  FragmentJob();
  FragmentJob(const std::string &_command, const std::string &_outputfile, const JobId_t _JobId);
  ~FragmentJob();

  FragmentResult Work();

  bool operator==(const FragmentJob &other) const;

  bool operator!=(const FragmentJob &other) const {
    return !(*this == other);
  }

  //!> string containing the command to launch the solver
  std::string command;

  //!> string containing the configuration file for the solver
  std::string outputfile;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<JobId>(*this);
    ar & command;
    ar & outputfile;
  }
};


#endif /* FRAGMENTJOB_HPP_ */
